# coding: iso-8859-1




class Interface

  def self.splash

    lines = []
    lines << "###############################################################################"
    lines << "#                                                                             #"
    lines << "#                                                                             #"
    lines << "#   DDDD   DDDD   DDDD   DDD    DD          DD                                #"
    lines << "#   D   D  D   D  D     D   D   DDDD      DDDD                                #"
    lines << "#   D   D  D DD   DDD   DDDDD   DD  DD  DD  DD                                #"
    lines << "#   D   D  D   D  D     D   D   DD    DD    DD                                #"
    lines << "#   DDDD   D   D  DDDD  D   D   DD          DD    DDD   D   D  DDDD  DDDD     #"
    lines << "#                               DD          DD   D   D  D  D   D     D   D    #"
    lines << "#                               DD          DD   DDDDD  DDD    DD    D DD     #"
    lines << "#                               DD          DD   D   D  D  D   D     D   D    #"
    lines << "#                               DD          DD   D   D  D   D  DDDD  D   D    #"
    lines << "#                                                                             #"
    lines << "#                                                                             #"
    lines << "###############################################################################"
    lines << "                                                                               "
    lines << "                                                                   version X.X "
    lines << " By King Kadelfek                                                              "
    lines << "                                                                               "
    lines << "                        2007 - 2011 All rights reserved                        "
    lines << "                                                                               "
    lines << "                                                                               "
    lines << "                                                                               "

    # Indication du numro de version
    str = lines[16]

    str.sub!(/version .*$/, "version #{$dmk_version}")
    str.strip!
    str << " "
    str.replace(str.rjust(79))



    screen_clear
    putss lines.join("\n")

    pause

  end

  # Ajoute des tirets de part et d'autre d'une phrase
  def self.tiret(str)

    max = 40
  
    moitie = (max-str.size-2)/2
    if moitie <= 0
      return sprintf "- %s -", str
    end

    return "-"*moitie+" "+str+" "+"-"*(max-moitie-str.size-2)

  end



  def self.putss_t(str)
    phr = traduire(str)
    #p str, phr, phr.size
    putss tiret(phr)
  end



  # Gre l'interface en mode texte du programme
  def self.interface

    while true
      screen_clear
      putss titre
      print "1 : " ; putss "#10 Dcompiler les fichiers RM en fichiers DMK"
      print "2 : " ; putss "#11 Extraire les dialogues des fichiers DMK"
      print "3 : " ; putss "#12 Inclure les dialogues dans les fichiers DMK"
      print "4 : " ; putss "#13 Compiler les fichiers DMK en fichiers RM"
      print "5 : " ; putss "#14 (dsactiv) Patch de dialogues"
      print "6 : " ; putss "#29 (dsactiv) Pourcentage Maker"
      print "7 : " ; putss "#30 (dsactiv) Redimensionner les dialogues"
      print "8 : " ; putss "#28 (dsactiv) Dtecter les ressources manquantes"
      print "9 : " ; putss "#107 Aller sur le site de DreaMaker"
      print "0 : " ; putss "#15 Quitter"

      rep = -1

      printt "#23 choix : "
      rep = gets.chop
  
      if /pirate/i.match(rep) then pirater ; redo end
  
      rep = rep.to_i

      break if rep >= 0 and rep <= 9
    end

    case rep
    when 1
      return decompiler # ETAPE 1
      #$ctl.executer(:decompiler, true) 
    when 2
      #return extraire
      $ctl.executer(:dmk_dialogs_extraction) # ETAPE 2
    when 3
      $ctl.executer(:dmk_dialogs_inclusion) # ETAPE 3
    when 4
      return compiler # ETAPE 4
    when 5
      #$ctl.executer(:creer_patch_dialogue) # ETAPE 5
      return false
    when 6
      #$ctl.executer(:creer_pourcentage_maker) # ETAPE 6
      return false
    when 7
      return false
      #return redimensionner # ETAPE 7
    when 8
      return false
      $ctl.executer(:detecter_ressource) # ETAPE 8
    when 9
      $ctl.executer(:dmk_go_website)
    when 0
      return 0
      #raise InterfaceException
    else
      putss "pas de rep"
      pause
      return false
    
    end


  end

  def self.titre
    titre = tiret("DreaMaker v#{$dmk_version}")
    titre << "\n" << tiret("RMXP")
    #titre << "\n" << "-"*((titre.size-6)/2)+" RMXP "+"-"*((titre.size-6)/2) if $rmxp == true
    return titre
  end

  def self.decompiler

    while true
      screen_clear
      putss titre
      putss ""
      putss_t("#10 Dcompiler les fichiers RM en fichiers DMK")
      print "1 : "; putss("#17 Dcompiler tous les fichiers")
      print "2 : "; putss("#18 Dcompiler seulement les fichiers modifis")
      print "0 : "; putss("#19 Retour")

      rep = -1

      printt "#23 choix : "
      rep = gets.chop.to_i

      break if rep >= 0 and rep <= 2
    end


    case rep
    when 1
      $ctl.executer(:dmk_convert_to_dmk, true)
    when 2
      $ctl.executer(:dmk_convert_to_dmk, false)
    end

    pause if exe?
    return

  end


  def self.compiler

    while true
      screen_clear
      putss titre
      puts ""
      putss_t "#13 Compiler les fichiers DMK en fichiers RM"
      print "1 : "; putss("#21 Compiler tous les fichiers")
      print "2 : "; putss("#22 Compiler seulement les fichiers modifis")
      print "0 : "; putss("#19 Retour")
  
      rep = -1

      printt "#23 choix : "
      rep = gets.chop.to_i

      break if rep >= 0 and rep <= 2
    end


    case rep
    when 1
      $ctl.executer(:dmk_convert_to_rm, true)
    when 2
      $ctl.executer(:dmk_convert_to_rm, false)
    end

    pause
    return

  end



  def self.extraire

    while true
      screen_clear
      putss titre
      puts ""
      putss_t "99 Extraire les dialogues"
      putss "1 : Extraire les dialogues de tous les fichiers DMK"
      #putss "2 : Compiler les maps modifiees (pas disponible)"
      putss "0 : Retour"

      rep = -1

      printt "#23 choix : "
      rep = gets.chop.to_i

      break if rep >= 0 and rep <= 1
    end


    case rep
    when 1
      extraire_dialogue(true)
    when 2
      putss "pas disponible"
    end

    pause
    return

  end


  def self.redimensionner


    while true
      redimensionner_commun
      print "1 : " ; putss("#89 Redimensionner avec ces paramtres")
      print "2 : " ; putss("#35 Changer les paramtres")
      print "0 : " ; putss("#19 Retour")
      putss ""

      printt "#23 choix : "
      rep = gets.chop.to_i

      break if rep >= 0 and rep <= 2

    end

    case rep
    when 1
      $ctl.executer(:dmk_dialogs_resize)
    when 2
      redimensionner_changer
      redimensionner
    when 0
      pause
    end

  
    return

  end



  def self.redimensionner_commun

    resize = $options.resize
    plus_grand = (resize.chacun_nb_index(0)).str_biggest.size

    resize_txt = ""
    for resz in resize
      resize_txt << "  - #{resz[0].ljust(plus_grand)} : #{resz[1]}\n"
    end

    screen_clear
    putss titre
    putss "#90 Redimensionner les dialogues"
    puts "-"*38
    putss "#86 Paramtres actuels : "
    putss resize_txt
    puts "-"*38
  end



  def self.redimensionner_changer


    reg = /^(.+) *\* *(\d+) *\* *(\d+) *\* *(\d+)$/

    while true
      redimensionner_commun
      putss "#100 Tapez de nouveaux paramtres spars par *\nExemple : Times New Roman*19*3*450\n(casse et espaces obligatoires pour les polices)"
      
      printt "#47 Entrez les donnes : "
      rep = gets.chop

      return if rep == ""

      m = reg.match(rep)

      if m != nil
        if m.size == 5
          # On retire les ventuels espaces sur le ct. Pas  l'intrieur !
          n = []
          for i in 1...5
            n[i] = m[i].strip
          end

          police = n[1]
          taille = n[2].to_i
          nb_lignes = n[3].to_i
          width = n[4].to_i

          $options["resize_font_name"] = police
          $options["resize_font_size"] = taille
          $options["resize_lines"] = nb_lignes
          $options["resize_width"] = width

        
          putss "#93 Sauvegarde des informations."
          puts "..."
          $options.ini_save
          putss "#55 Informations sauvegards."
          pause
        
          break
        end
      end


      putss "#48 Erreur dans la saisie. Veuillez recommencer."
      pause

    end


    return



  end


  def self.dialogue_maj_old


    while true
      screen_clear
      putss titre
      putss_t "Mise  jour des dialogues"
      puts ""
      putss "Souhaitez-vous mettre le fichier dialogues  jour ?"
      puts ""
      putss "#Note : cela est vraiment conseill (sauf si vous avez eu des erreurs prcdemment)."
      puts ""
      print "1 : "; putss("#85 Oui")
      print "2 : "; putss("#81 Non")
      print "0 : "; putss("#19 Retour")

      rep = -1

      printt "#23 choix : "
      rep = gets.chop.to_i

      break if rep >= 0 and rep <= 2
    end

  

    case rep
    when 1
      return true
    when 2
      return false
    end

    
    return


  end


  def self.screen_clear
    system "cls" if exe? == true
  end




  def self.new_version(version, message)

    while true
      screen_clear
      putss_t("DreaMaker v#{version}")
      puts ""
      putss("#41 DreaMaker v%s est disponible !", version)
      puts ""
      putss("#83 Nouveauts :")
      putss message
      puts ""

      print "1 : "; putss("#104 Tlcharger la nouvelle version (recommand)")
      print "0 : "; putss("#91 Refuser")

      rep = -1

      printt "#23 choix : "
      rep = gets.chop.to_i

      break if rep >= 0 and rep <= 1
    end


    case rep
    when 0
      putss "#83 Opration annule"
    when 1
      putss "#87 Pour installer la nouvelle version :\n- Incluez toutes vos modifications dans les fichiers RM (tapes 3 et 4)\n- Supprimez DreaMaker.exe et tous ses fichiers et dossiers (DMK) du dossier de votre jeu\n- Mettez le nouvel excutable (DreaMaker.exe) dans le dossier\n\nRetrouvez ces informations dans le manuel."
      Launchy.open(DMK_WEBSITE)
    end

    pause if exe?
    return

  end




end